using System;
using Borland.Eco.Services;
using Borland.Eco.UmlCodeAttributes;

namespace CustomOclOperations
{
	[EcoSpace]
	[EcoSpacePackage(typeof(CustomOclOperations.CoreClassesPackage))]
	public class CustomOclOperationsEcoSpace: Borland.Eco.Handles.DefaultEcoSpace
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Persistence.PersistenceMapperBdp persistenceMapperBdp1;
		private void InitializeComponent()
		{
			this.persistenceMapperBdp1 = new Borland.Eco.Persistence.PersistenceMapperBdp();
			// 
			// persistenceMapperBdp1
			// 
			this.persistenceMapperBdp1.SqlDatabaseConfig.DefaultDateTime = new System.DateTime(((long)(0)));
			this.persistenceMapperBdp1.SqlDatabaseConfig.DefaultStringLength = 255;
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropColumnTemplate = "ALTER TABLE <TableName> DROP <ColumnName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropIndexTemplate = "DROP INDEX <IndexName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropTableTemplate = "DROP TABLE <TableName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.FetchBlockSize = 250;
			this.persistenceMapperBdp1.SqlDatabaseConfig.MaxParamsInIdList = 20;
			this.persistenceMapperBdp1.SqlDatabaseConfig.ReservedWords = "ACTIVE,ADD,ALL,AFTER,ALTER,AND,ANY,AS,ASC,ASCENDING,AT,AUTO,AUTOI" +  
				"NC,AVG,BASE_NAME,BEFORE,BEGIN,BETWEEN,BLOB,BOOLEAN,BOTH,BY,BYTES," +  
				"CACHE,CAST,CHAR,CHARACTER,CHECK,CHECK_POINT_LENGTH,COLLATE,COLUMN" +  
				",COMMIT,COMMITTED,COMPUTED,CONDITIONAL,CONSTRAINT,CONTAINING,COUN" +  
				"T,CREATE,CSTRING,CURRENT,CURSOR,DATABASE,DATE,DAY,DEBUG,DEC,DECIM" +  
				"AL,DECLARE,DEFAULT,DELETE,DESC,DESCENDING,DISTINCT,DO,DOMAIN,DOUB" +  
				"LE,DROP,ELSE,END,ENTRY_POINT,ESCAPE,EXCEPTION,EXECUTE,EXISTS,EXIT" +  
				",EXTERNAL,EXTRACT,FILE,FILTER,FLOAT,FOR,FOREIGN,FROM,FULL,FUNCTIO" +  
				"N,GDSCODE,GENERATOR,GEN_ID,GRANT,GROUP,GROUP_COMMIT_WAIT_TIME,HAV" +  
				"ING,HOUR,IF,IN,INT,INACTIVE,INDEX,INNER,INPUT_TYPE,INSERT,INTEGER" +  
				",INTO,IS,ISOLATION,JOIN,KEY,LONG,LENGTH,LOGFILE,LOWER,LEADING,LEF" +  
				"T,LEVEL,LIKE,LOG_BUFFER_SIZE,MANUAL,MAX,MAXIMUM_SEGMENT,MERGE,MES" +  
				"SAGE,MIN,MINUTE,MODULE_NAME,MONEY,MONTH,NAMES,NATIONAL,NATURAL,NC" +  
				"HAR,NO,NOT,NULL,NUM_LOG_BUFFERS,NUMERIC,OF,ON,ONLY,OPTION,OR,ORDE" +  
				"R,OUTER,OUTPUT_TYPE,OVERFLOW,PAGE_SIZE,PAGE,PAGES,PARAMETER,PASSW" +  
				"ORD,PLAN,POSITION,POST_EVENT,PRECISION,PROCEDURE,PROTECTED,PRIMAR" +  
				"Y,PRIVILEGES,RAW_PARTITIONS,RD,DB_KEY,READ,REAL,RECORD_VERSION,RE" +  
				"FERENCES,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,REVOKE," +  
				"RIGHT,ROLE,ROLLBACK,SECOND,SEGMENT,SELECT,SET,SHARED,SHADOW,SCHEM" +  
				"A,SINGULAR,SIZE,SMALLINT,SNAPSHOT,SOME,SORT,SQLCODE,STABILITY,STA" +  
				"RTING,STARTS,STATISTICS,SUB_TYPE,SUBSTRING,SUM,SUSPEND,TABLE,THEN" +  
				",TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSAC" +  
				"TION,TRIGGER,TRIM,UNCOMMITTED,UNION,UNIQUE,UPDATE,UPPER,USER,VALU" +  
				"E,VALUES,VARCHAR,VARIABLE,VARYING,VIEW,WAIT,WHEN,WHERE,WHILE,WITH" +  
				",WORK,WRITE,YE,";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SQLforNotNull = "NOT NULL";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommentStart = "/* ";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommentStop = " */";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommitTransaction = "COMMIT";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptRollBackTransaction = "ROLLBACK";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptSeparator = "---";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptStartTransaction = "START TRANSACTION";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptTerminator = ";";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SupportsConstraintsInCreateTable = true;
			this.persistenceMapperBdp1.SqlDatabaseConfig.SystemTablePrefix = "ECO";
			this.persistenceMapperBdp1.SqlDatabaseConfig.UseSQL92Joins = false;
			this.persistenceMapperBdp1.VersionGranularity = System.TimeSpan.Parse("00:00:00");
		}

		public CustomOclOperationsEcoSpace(): base()
		{
			InitializeComponent();
			// this installs the two methods "reverseString" and "standardDeviation"
			// they will not be accessible in designtime but will work in runtime
			OclService.InstallOperation(new ReverseStringOclOp());
			OclService.InstallOperation(new StandardDeviationOclOp());
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				Active = false;
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		private static ITypeSystemService m_TypeSystemProvider;
		public static new ITypeSystemService GetTypeSystemService()
		{
		if (m_TypeSystemProvider == null)
				lock(typeof(CustomOclOperationsEcoSpace))
				{
					if (m_TypeSystemProvider == null)
						m_TypeSystemProvider = MakeTypeService(typeof(CustomOclOperationsEcoSpace));
				}
			return m_TypeSystemProvider;
		}
		protected override ITypeSystemService GetTypeSystemProvider()
		{
			return CustomOclOperationsEcoSpace.GetTypeSystemService();
		}
		//
		// Services
		//
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)GetEcoService(typeof(IDirtyListService)); }
		}
		public IUndoService UndoService
		{
			get { return (IUndoService)GetEcoService(typeof(IUndoService)); }
		}
		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService)); }
		}
		//
		// Misc helper functions
		//
		public void UpdateDatabase()
		{
			if ((PersistenceService != null) && (DirtyListService != null))
			{
				PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
			}
		}
		//
		// Add user written methods here
		//
	}
}
